package fr.asip.cps3.exemple.modele.exceptions;


/**
 * Classe d'exception applicative intervenant de faon inattendue lors de la ralisation de traitements
 */
public class ExceptionTraitement extends ExceptionProgrammeExemple {
	
	private static final long serialVersionUID = 7649690258362339256L;
	
	/**
	 * Code du type de traitement
	 */
	private int typeTraitement = -1;
	
	/**
	 * Constructeur
	 * @param typeTraitement Code du type de traitement
	 */
	public ExceptionTraitement(int typeTraitement) {
		super();
		this.typeTraitement = typeTraitement;
	}

	/**
	 * Constructeur
	 * @param typeTraitement Code du type de traitement 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionTraitement(int typeTraitement, String message, Throwable cause) {
		super(message, cause);
		this.typeTraitement = typeTraitement;
	}

	/**
	 * Constructeur
	 * @param typeTraitement Code du type de traitement 
	 * @param message Intitul de l'exception
	 */
	public ExceptionTraitement(int typeTraitement, String message) {
		super(message);
		this.typeTraitement = typeTraitement;
	}

	/**
	 * Constructeur
	 * @param typeTraitement Code du type de traitement 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionTraitement(int typeTraitement, Throwable cause) {
		super(cause);
		this.typeTraitement = typeTraitement;
	}

	/**
	 * Accesseur
	 * @return le code du type de traitement
	 */
	public int getTypeTraitement() {
		return typeTraitement;
	}

	/**
	 * Dtermine le type d'exception
	 * @return Le type d'exception
	 */
	public String getTypeException() {
		
		switch(typeTraitement) {
		
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERAL_INFO_LIB:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERAL_INIT_LIB:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERAL_TERMIN_LIB:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_ATTENTE_EVENEMENT_SLOT:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_SLOTS_TOUS:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_SLOTS_AVEC_CARTE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_SLOT:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_CARTE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_ALGO:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_ALGO:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INIT_PIN:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_MODIF_PIN:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_OUVRE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_INFO:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_FERME:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_FERME_TOUTES:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_AUTHENTIFIE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_DECONNECTE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_CREER:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_COPIE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_SUPPR:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_TAILLE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_AFFICHE_ATTRIBUT:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_MODIF_ATTRIBUT:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_MESSAGE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_FICHIER:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SIGNATURES_MESSAGE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SIGNATURES_FICHIER:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_VERIFICATION_FICHIER:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_VERIFICATION_MESSAGE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERATIONALEATOIRE_NORMALE:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERATIONALEATOIRE_SEED:
				return ("Erreur fonctions PKCS#11");

				
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_INITIALISATION:
			case ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_ASSISTANT_AUTHENTIFICATION:
				return ("Erreur traitement spcifique");			
			
			
			default:
				return "Erreur traitement";
		}
			
	}
}
